import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiCloseDialog from "alexandria-ui-elements/src/displays/components/CloseDialog";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiDecisionDialog from "alexandria-ui-elements/src/displays/components/DecisionDialog";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiImageAvatar from "alexandria-ui-elements/src/displays/components/ImageAvatar";
import UiAlertDialog from "alexandria-ui-elements/src/displays/components/AlertDialog";
import UiCollectionDialog from "alexandria-ui-elements/src/displays/components/CollectionDialog";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import DisplaysDialog4ListMold from "ui-elements/gen/displays/items/Dialog4ListMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DialogExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DialogExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DialogExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DialogExamplesMoldNotifier(this);
		this.requester = new DialogExamplesMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112" layout="horizontal wrap" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447.a_334408173" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447.a_64500432" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447.a_64500432.a417224357" title="custom dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447.a_64500432.a_671637708" format="containerAirLarge" title="custom dialog">
								<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447.a_64500432.a_671637708.a_566617630" mode="normal" placeholder="field 1">
								</UiTextEditable>
								<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447.a_64500432.a_671637708.a_566617629" mode="normal" placeholder="field 2">
								</UiTextEditable>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447.a_64500432.a_671637708.a1651116930" format="airTop" layout="horizontal endjustified" spacing="8">
									<UiCloseDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447.a_64500432.a_671637708.a1651116930.a_1606975591" title="Close" target="self" mode="Button" size="Medium">
									</UiCloseDialog>
									<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447.a_64500432.a_671637708.a1651116930.a_490525048" title="Accept" target="self" mode="Button" size="Medium">
									</UiAction>
								</UiBlock>
							</UiDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447.a_2114941856" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a333447447.a_2114941856.a_218346572" mode="normal" language="Html" value="Button(title=&quot;custom dialog&quot;) as OpenDialog(dialog=dialog)
							Dialog(format=containerAirLarge, title = &quot;custom dialog&quot;) dialog
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text field1 as Editable
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text field2 as Editable
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal EndJustified)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Button(title=&quot;Close&quot;) as CloseDialog(dialog=dialog)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Button(title=&quot;Accept&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a11036417" format="h6" mode="normal" value="No facets. Decision dialog">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a_946317072" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a_946317072.a548379882" title="decision dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiDecisionDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a_946317072.a287592309" format="containerAirLarge" title="decision dialog">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a_946317072.a287592309.a_724778008" multipleSelection={false}>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a_946317072.a287592309.a_724778008.a158632197" name="option1" layout="horizontal center" spacing="8">
										<UiImageAvatar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a_946317072.a287592309.a_724778008.a158632197.a_1928793176">
										</UiImageAvatar>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a_946317072.a287592309.a_724778008.a158632197.a168878069" mode="normal" value="Option 1">
										</UiText>
									</UiBlock>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a_946317072.a287592309.a_724778008.a158632198" name="option2" layout="horizontal center" spacing="8">
										<UiImageAvatar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a_946317072.a287592309.a_724778008.a158632198.a2120626323">
										</UiImageAvatar>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a_946317072.a287592309.a_724778008.a158632198.a_76729064" mode="normal" value="Option 2">
										</UiText>
									</UiBlock>
								</UiSelectorListBox>
							</UiDecisionDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a1623607658" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_77001793.a1623607658.a_44270352" mode="normal" language="Html" value="Button(title=&quot;decision dialog&quot;) as OpenDialog(dialog=dialog)
							DecisionDialog(format=containerAirLarge, title = &quot;decision dialog&quot;) dialog
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector selector1 as ComboBox
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text option1 as Option Labeled(&quot;Option 1&quot;)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text option2 as Option Labeled(&quot;Option 2&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a46532636" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a46532636.a_1526185460" format="h6" mode="normal" value="No facets. Alert dialog">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a46532636.a_2021501149" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a46532636.a_2021501149.a1407164336" title="alert dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiAlertDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a46532636.a_2021501149.a1246822326" format="containerAirLarge" title="alert dialog" message="Intino is cool!" closeLabel="Cancel" width="350px" height="-1px">
							</UiAlertDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a46532636.a391840522" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a46532636.a391840522.a68248261" mode="normal" language="Html" value="Button(title=&quot;alert dialog&quot;) as OpenDialog(dialog=dialog)
							AlertDialog(format=containerAirLarge, title = &quot;alert dialog&quot;) dialog as Absolute(width=350px)
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;message = &quot;Intino is cool!&quot;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;acceptLabel = &quot;OK!&quot;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1536443516" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1536443516.a251609247" format="h6" mode="normal" value="No facets. Collection dialog">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1536443516.a_2068273357" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1536443516.a_2068273357.a_1633132426" title="collection dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiCollectionDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1536443516.a_2068273357.a102858609" format="containerAirLarge" title="collection dialog" width="80.0%" height="60.0%">
								<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1536443516.a_2068273357.a102858609.a1655057669" pageSize={20} itemHeight={30} scrollingMark={true} selection="single">
								</UiList>
							</UiCollectionDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1536443516.a19731576" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1536443516.a19731576.a1246924005" mode="normal" language="Html" value="Button(title=&quot;collection dialog&quot;) as OpenDialog(dialog=dialog)
							CollectionDialog(format=containerAirLarge, title = &quot;collection dialog&quot;) dialog
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;allowSearch = true
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;List list1 as Selectable &gt; Mold &gt; Item(height = 100px) itemMold">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1461366918" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1461366918.a2076950179" format="h6" mode="normal" value="Fullscreen facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1461366918.a27897803" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1461366918.a27897803.a_951873470" title="fullscreen dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiAlertDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1461366918.a27897803.a538183704" format="containerAirLarge" title="full screen dialog" fullscreen={true} message="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce lobortis lacinia leo, sed fringilla libero. Pellentesque at venenatis orci. Sed enim sem, blandit vel massa ut, semper blandit sapien. Suspendisse potenti. Etiam euismod nibh a scelerisque placerat. Duis maximus eget ipsum pretium auctor. Mauris malesuada metus vel dolor laoreet, eget mollis mauris condimentum. Interdum et malesuada fames ac ante ipsum primis in faucibus. Nam id nisl nibh. Mauris mattis nulla non lacinia tincidunt. Ut id orci sit amet nisl viverra rutrum in eu neque.
							                               Donec ac ex in nisl feugiat sagittis. Curabitur vehicula sed felis nec blandit. Mauris eu urna at dui feugiat laoreet. Aliquam iaculis feugiat scelerisque. Maecenas suscipit est mauris, non aliquet metus molestie in. Suspendisse finibus malesuada ante et dapibus. Mauris et dapibus massa, eu posuere nunc. Ut a lacus lectus. Morbi non vulputate eros. Morbi egestas vehicula risus, egestas sollicitudin velit elementum in. Nulla ut euismod tortor. Vestibulum tempor justo fringilla mollis hendrerit." closeLabel="OK!" width="350px" height="-1px">
							</UiAlertDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1461366918.a_1270532386" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a1461366918.a_1270532386.a1439286949" mode="normal" language="Html" value="Button(title=&quot;fullscreen dialog&quot;) as OpenDialog(dialog=dialog)
							AlertDialog(format=containerAirLarge, title = &quot;full screen dialog&quot;) dialog as Absolute(width=350px) Fullscreen
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;message = &quot;Intino is cool!&quot;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;acceptLabel = &quot;OK!&quot;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_1544394843" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_1544394843.a138360290" format="h6" mode="normal" value="Modal facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_1544394843.a_1776512212" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_1544394843.a_1776512212.a1150414401" title="modal dialog" target="self" mode="Button" size="Medium">
							</UiOpenDialog>
							<UiAlertDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_1544394843.a_1776512212.a_1567350911" format="containerAirLarge" title="full screen dialog" modal={true} message="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce lobortis lacinia leo, sed fringilla libero. Pellentesque at venenatis orci. Sed enim sem, blandit vel massa ut, semper blandit sapien. Suspendisse potenti. Etiam euismod nibh a scelerisque placerat. Duis maximus eget ipsum pretium auctor. Mauris malesuada metus vel dolor laoreet, eget mollis mauris condimentum. Interdum et malesuada fames ac ante ipsum primis in faucibus. Nam id nisl nibh. Mauris mattis nulla non lacinia tincidunt. Ut id orci sit amet nisl viverra rutrum in eu neque.
							                               Donec ac ex in nisl feugiat sagittis. Curabitur vehicula sed felis nec blandit. Mauris eu urna at dui feugiat laoreet. Aliquam iaculis feugiat scelerisque. Maecenas suscipit est mauris, non aliquet metus molestie in. Suspendisse finibus malesuada ante et dapibus. Mauris et dapibus massa, eu posuere nunc. Ut a lacus lectus. Morbi non vulputate eros. Morbi egestas vehicula risus, egestas sollicitudin velit elementum in. Nulla ut euismod tortor. Vestibulum tempor justo fringilla mollis hendrerit." closeLabel="OK!" width="60.0%" height="40.0%">
							</UiAlertDialog>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_1544394843.a_1409722486" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1125757112.a_1544394843.a_1409722486.a1748963084" mode="normal" language="Html" value="Button(title=&quot;fullscreen dialog&quot;) as OpenDialog(dialog=dialog)
							AlertDialog(format=containerAirLarge, title = &quot;full screen dialog&quot;) dialog as Absolute(width=350px) Modal
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;message = &quot;Intino is cool!&quot;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;acceptLabel = &quot;OK!&quot;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DialogExamplesMold));
DisplayFactory.register("DialogExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DialogExamplesMold)));