import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysTextExamplesMold from "ui-elements/gen/displays/templates/TextExamplesMold";
import DisplaysNumberExamplesMold from "ui-elements/gen/displays/templates/NumberExamplesMold";
import DisplaysFileExamplesMold from "ui-elements/gen/displays/templates/FileExamplesMold";
import DisplaysImageExamplesMold from "ui-elements/gen/displays/templates/ImageExamplesMold";
import DisplaysDateExamplesMold from "ui-elements/gen/displays/templates/DateExamplesMold";
import DisplaysChartExamplesMold from "ui-elements/gen/displays/templates/ChartExamplesMold";
import DisplaysBlockExamplesMold from "ui-elements/gen/displays/templates/BlockExamplesMold";
import DisplaysListExamplesMold from "ui-elements/gen/displays/templates/ListExamplesMold";
import DisplaysTableExamplesMold from "ui-elements/gen/displays/templates/TableExamplesMold";
import DisplaysDynamicTableExamplesMold from "ui-elements/gen/displays/templates/DynamicTableExamplesMold";
import DisplaysMapExamplesMold from "ui-elements/gen/displays/templates/MapExamplesMold";
import DisplaysDownloadExamplesMold from "ui-elements/gen/displays/templates/DownloadExamplesMold";
import DisplaysDownloadSelectionExamplesMold from "ui-elements/gen/displays/templates/DownloadSelectionExamplesMold";
import DisplaysExportExamplesMold from "ui-elements/gen/displays/templates/ExportExamplesMold";
import DisplaysActionableExamplesMold from "ui-elements/gen/displays/templates/ActionableExamplesMold";
import DisplaysGroupingExamplesMold from "ui-elements/gen/displays/templates/GroupingExamplesMold";
import DisplaysGroupingToolbarExamplesMold from "ui-elements/gen/displays/templates/GroupingToolbarExamplesMold";
import DisplaysSortingExamplesMold from "ui-elements/gen/displays/templates/SortingExamplesMold";
import DisplaysSearchBoxExamplesMold from "ui-elements/gen/displays/templates/SearchBoxExamplesMold";
import DisplaysSliderExamplesMold from "ui-elements/gen/displays/templates/SliderExamplesMold";
import DisplaysDashboardExamplesMold from "ui-elements/gen/displays/templates/DashboardExamplesMold";
import DisplaysDialogExamplesMold from "ui-elements/gen/displays/templates/DialogExamplesMold";
import DisplaysDividerExamplesMold from "ui-elements/gen/displays/templates/DividerExamplesMold";
import DisplaysUserExamplesMold from "ui-elements/gen/displays/templates/UserExamplesMold";
import DisplaysLocationExamplesMold from "ui-elements/gen/displays/templates/LocationExamplesMold";
import DisplaysSelectorExamplesMold from "ui-elements/gen/displays/templates/SelectorExamplesMold";
import DisplaysStepperExamplesMold from "ui-elements/gen/displays/templates/StepperExamplesMold";
import DisplaysFrameExamplesMold from "ui-elements/gen/displays/templates/FrameExamplesMold";
import DisplaysMicroSiteExamplesMold from "ui-elements/gen/displays/templates/MicroSiteExamplesMold";
import DisplaysPropertyMold from "ui-elements/gen/displays/templates/PropertyMold";
import DisplaysMethodMold from "ui-elements/gen/displays/templates/MethodMold";
import DisplaysEventsDisplay from "ui-elements/src/displays/EventsDisplay";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import WidgetMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import WidgetMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class WidgetMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new WidgetMoldNotifier(this);
		this.requester = new WidgetMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderDynamicLoaded(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1078556726" format="h3" mode="normal" value="Widget">
				</UiText>
				<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_133628978" format="body1" multiple={{instances:"highlightFacets",arrangement:"Horizontal",noItemsMessage:"",spacing:0,editable:false,wrap:true,count:{min:0,max:-1}}} mode="normal" highlighted={{text:"white",background:"#679164"}}>
				</UiMultiple>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1216248666" format="body1 airBottom" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a423938414" layout="vertical" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a926463903" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a712549103" format="h5 underline" mode="normal" value="Examples">
						</UiText>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_37186250" layout="vertical">
							<DisplaysTextExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1152715418">
							</DisplaysTextExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1569761106" layout="vertical">
							<DisplaysNumberExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1853170798">
							</DisplaysNumberExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1037007227" layout="vertical">
							<DisplaysFileExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1433807798">
							</DisplaysFileExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1940776484" layout="vertical">
							<DisplaysImageExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a295795327">
							</DisplaysImageExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1376571721" layout="vertical">
							<DisplaysDateExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1651642659">
							</DisplaysDateExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_447880793" layout="vertical">
							<DisplaysChartExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372744781">
							</DisplaysChartExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1285705898" layout="vertical">
							<DisplaysBlockExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_76655350">
							</DisplaysBlockExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1314848679" layout="vertical">
							<DisplaysListExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1807761995">
							</DisplaysListExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1320200809" layout="vertical">
							<DisplaysTableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1786719541">
							</DisplaysTableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_153474856" layout="vertical">
							<DisplaysDynamicTableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1252713438">
							</DisplaysDynamicTableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a363309349" layout="vertical">
							<DisplaysMapExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1734915046">
							</DisplaysMapExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1147781743" layout="vertical">
							<DisplaysDownloadExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1271623093">
							</DisplaysDownloadExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a331314605" layout="vertical">
							<DisplaysDownloadSelectionExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1093394610">
							</DisplaysDownloadSelectionExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1866679485" layout="vertical">
							<DisplaysExportExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a34654326">
							</DisplaysExportExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1182354841" layout="vertical">
							<DisplaysActionableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a392516213">
							</DisplaysActionableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1435015412" layout="vertical">
							<DisplaysGroupingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1761683811">
							</DisplaysGroupingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1892484289" layout="vertical">
							<DisplaysGroupingToolbarExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1064993127">
							</DisplaysGroupingToolbarExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a727449933" layout="vertical">
							<DisplaysSortingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a449245944">
							</DisplaysSortingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_756988980" layout="vertical">
							<DisplaysSearchBoxExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1783719707">
							</DisplaysSearchBoxExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1867328746" layout="vertical">
							<DisplaysSliderExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1629744471">
							</DisplaysSliderExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1476972963" layout="vertical">
							<DisplaysDashboardExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a204119393">
							</DisplaysDashboardExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_45393327" layout="vertical">
							<DisplaysDialogExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2025837737">
							</DisplaysDialogExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_509847070" layout="vertical">
							<DisplaysDividerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1100039274">
							</DisplaysDividerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_536887852" layout="vertical">
							<DisplaysUserExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1359160109">
							</DisplaysUserExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_318007362" layout="vertical">
							<DisplaysLocationExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_143356806">
							</DisplaysLocationExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1952981480" layout="vertical">
							<DisplaysSelectorExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2023743063">
							</DisplaysSelectorExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a870299034" layout="vertical">
							<DisplaysStepperExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_111549760">
							</DisplaysStepperExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2007649226" layout="vertical">
							<DisplaysFrameExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_442998118">
							</DisplaysFrameExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a682118388" layout="vertical">
							<DisplaysMicroSiteExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_166782653">
							</DisplaysMicroSiteExamplesMold>
						</UiBlockConditional>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2064267890" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2099561759" format="h5 underline" mode="normal" value="Facets">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_216906561" mode="normal">
						</UiText>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1163715518" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1153015402" format="h5 underline" mode="normal" value="Properties">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_326743835" multiple={{instances:"properties",arrangement:"Vertical",noItemsMessage:"no properties",spacing:0,editable:false,wrap:true,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_664743633" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a159333554" format="h5 underline" mode="normal" value="Methods">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1202754947" multiple={{instances:"methods",arrangement:"Vertical",noItemsMessage:"no methods",spacing:0,editable:false,wrap:true,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a604728957" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2075522712" format="h5 underline" mode="normal" value="Events">
						</UiText>
						<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a512046096">
						</UiDisplayStamp>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold));
DisplayFactory.register("WidgetMold", withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold)));