import PageCollectionRequester from "./PageCollectionRequester"

export default class DynamicTableRequester extends PageCollectionRequester {
	constructor(element) {
		super(element);
	};
	selectRow = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "selectRow", s: "dynamictable", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	showItems = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "showItems", s: "dynamictable", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "dynamictable", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}