import PageCollectionNotifier from "./PageCollectionNotifier"

export default class DynamicTableNotifier extends PageCollectionNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("setup").toSelf().execute((parameters) => this.element.setup(parameters.v));
		this.when("sections").toSelf().execute((parameters) => this.element.sections(parameters.v));
		this.when("selectRowProvided").toSelf().execute((parameters) => this.element.selectRowProvided(parameters.v));
		this.when("openRow").toSelf().execute((parameters) => this.element.openRow(parameters.v));
		this.pushLinked = true;
	};
}