import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiStepper from "alexandria-ui-elements/src/displays/components/Stepper";
import UiStep from "alexandria-ui-elements/src/displays/components/Step";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiDate from "alexandria-ui-elements/src/displays/components/Date";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import StepperExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import StepperExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class StepperExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new StepperExamplesMoldNotifier(this);
		this.requester = new StepperExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a374716444" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1490939944" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_319154372" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a76606147" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1420588258" style="Full"    orientation="horizontal" position="bottom">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2128704132" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1050396840" mode="normal" value="hola1">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2128704133" label="Step2">
									<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1148711260" width="200px" height="150px">
									</UiImage>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2128704134" label="Step3">
									<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1412845760" pattern="DD/MM/YYYY">
									</UiDate>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1249091617" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_861224519" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step1 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;hola1&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step2 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image(defaultValue =&quot; images/image.jpg&quot;) as Absolute(width = 200px, height = 150px)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step3 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step3&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Date(pattern = &quot;DD/MM/YYYY&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1824899553" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a604596172" format="h6" mode="normal" value="No facet. Position top, Orientation horizontal">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_476206336" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1232897957" style="Full"    orientation="horizontal" position="top">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_360202748" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a249927451" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_360202747" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_346388928" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_10637036" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a801461818" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Top&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step4 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step5 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2092248860" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1083071017" format="h6" mode="normal" value="No facet. Position left, Orientation vertical">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a64714514" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536446724" style="Full"    orientation="vertical" position="left">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1315720209" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_726140990" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1315720208" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a945713394" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1025153290" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1483799517" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Left&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;orientation = Vertical&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step6 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step7 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a123155220" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1151413662" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a107848838" format="h6" mode="normal" value="No facet. Position right, Orientation vertical">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_345836058" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1982302463" style="Full"    orientation="vertical" position="right">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1503804500" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a229143172" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1503804499" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_367173207" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1166873717" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1675104697" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Right&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;orientation = Vertical&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step8 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step9 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1388278480" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1554671931" format="h6" mode="normal" value="MaterialIcon facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1076834559" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a375378727" style="Full"    orientation="horizontal" position="bottom">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471534589" label="Step1" icon="AddCircle">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1308074347" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471534588" label="Step2" icon="Menu">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_364389257" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a727990464" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_11911819" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step10 as Labeled MaterialIcon&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon = &quot;AddCircle&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step11 as Labeled MaterialIcon&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon = &quot;Menu&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(StepperExamplesMold));
DisplayFactory.register("StepperExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(StepperExamplesMold)));