import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorTabs from "alexandria-ui-elements/src/displays/components/SelectorTabs";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiSelectorMenu from "alexandria-ui-elements/src/displays/components/SelectorMenu";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiSelectorRadioBox from "alexandria-ui-elements/src/displays/components/SelectorRadioBox";
import UiSelectorToggleBox from "alexandria-ui-elements/src/displays/components/SelectorToggleBox";
import UiSelectorCheckBox from "alexandria-ui-elements/src/displays/components/SelectorCheckBox";
import UiSelectorCollectionBox from "alexandria-ui-elements/src/displays/components/SelectorCollectionBox";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import DisplaysSelector8ListMold from "ui-elements/gen/displays/items/Selector8ListMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import SelectorExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import SelectorExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class SelectorExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new SelectorExamplesMoldNotifier(this);
		this.requester = new SelectorExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_779869637" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a663049962" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_694442236" format="h6" mode="normal" value="Tabs facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_770967419" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorTabs context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_306608826" multipleSelection={false}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_685079136" name="tabOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_685079135" name="tabOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_685079134" name="tabOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorTabs>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1297677497" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1735140251" mode="normal" language="Html" value="Selector as Tabs&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) tabOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) tabOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) tabOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1351281763" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a741161947" format="h6" mode="normal" value="Menu facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a415264950" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorMenu context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1722381804" multipleSelection={false} layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1564631594" name="menuOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1564631595" name="menuOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1564631596" name="menuOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorMenu>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1264510417" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1042261203" mode="normal" language="Html" value="Selector as Menu(layout=Vertical)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) menuOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) menuOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) menuOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1700896257" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1771956668" format="h6" mode="normal" value="ComboBox facet with Traceable (cookie is used)">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_580210637" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1884876583" traceable={true} multipleSelection={false} maxMenuHeight={20}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a578658599" name="comboBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a578658600" name="comboBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a578658601" name="comboBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorComboBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_748090237" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_184469800" mode="normal" language="Html" value="Selector as ComboBox Traceable&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) comboBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) comboBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) comboBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1820700809" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1557015413" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a783002680" format="h6" mode="normal" value="ListBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_918667621" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_674503090" multipleSelection={false}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1907218272" name="listBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1907218273" name="listBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1907218274" name="listBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorListBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_175493485" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_366224122" mode="normal" language="Html" value="Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) listBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) listBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) listBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1354525089" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1230886494" format="h6" mode="normal" value="RadioBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a317473494" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorRadioBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_512008311" multipleSelection={false} selected="radioBoxOption1" layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_20870218" name="radioBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_20870217" name="radioBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_20870216" name="radioBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorRadioBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_79267168" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1282225334" mode="normal" language="Html" value="Selector as RadioBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) radioBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) radioBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) radioBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_993513629" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1415231208" format="h6" mode="normal" value="ToggleBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1194498100" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorToggleBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_349513532" multipleSelection={false} selected="toggleBoxOption1" layout="Horizontal" size="Medium">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a584957600" name="toggleBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a584957601" name="toggleBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a584957602" name="toggleBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorToggleBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_938704292" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_797554781" mode="normal" language="Html" value="Selector as ToggleBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) toggleBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) toggleBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) toggleBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a892026723" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1691152791" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1103214706" format="h6" mode="normal" value="CheckBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_33471188" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorCheckBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_765731418" multipleSelection={false} layout="Vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1142936736" name="checkBoxOption1" mode="normal" value="option 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1142936737" name="checkBoxOption2" mode="normal" value="option 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1142936738" name="checkBoxOption3" mode="normal" value="option 3">
								</UiText>
							</UiSelectorCheckBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_332133063" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_860576553" mode="normal" language="Html" value="Selector as CheckBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) checkBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) checkBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) checkBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1862839256" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1095698403" format="h6" mode="normal" value="CollectionBox facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_533156679" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiSelectorCollectionBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_603236639" multipleSelection={false} allowOther="true">
								<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1797190553selector8" pageSize={20} itemHeight={30} scrollingMark={true} selection="single">
								</UiList>
							</UiSelectorCollectionBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2097424882" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1615718792" mode="normal" language="Html" value="Selector as CollectionBox(allowOther=true)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) checkBoxOption1 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) checkBoxOption2 as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 3&quot;) checkBoxOption3 as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(SelectorExamplesMold));
DisplayFactory.register("SelectorExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(SelectorExamplesMold)));