import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMicroSite from "alexandria-ui-elements/src/displays/components/MicroSite";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import MicroSiteExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import MicroSiteExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class MicroSiteExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new MicroSiteExamplesMoldNotifier(this);
		this.requester = new MicroSiteExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1756484063" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1064115294" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_49651425" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2146912208" format="filledNoAirExtraLarge" layout="vertical">
							<UiMicroSite context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_524828993">
							</UiMicroSite>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1436513349" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a477331771" mode="normal" language="Html" value="MicroSite(site=empty) site">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(MicroSiteExamplesMold));
DisplayFactory.register("MicroSiteExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(MicroSiteExamplesMold)));