import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenPage from "alexandria-ui-elements/src/displays/components/OpenPage";
import UiBlockParallax from "alexandria-ui-elements/src/displays/components/BlockParallax";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HomeTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HomeTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class HomeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HomeTemplateNotifier(this);
		this.requester = new HomeTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a519599960" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_945759493" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_28121537" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_784503320" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a629331577" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_862574463" mode="normal" value="home">
							</UiText>
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_618972379" title="docs" target="self" mode="Link" size="Medium">
							</UiOpenPage>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1780601060" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_833186980" layout="vertical center" width="70.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1592440668" format="h1 textCentered" mode="normal" value="software production lines made easy">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a402233597" format="h2" mode="normal" value="symplifying software mass customization">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1575228427" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1120135163" format="containerAirLarge" layout="vertical">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_423231750" layout="vertical center" width="70.0%" height="100.0%" spacing="40">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_693712482" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_676512643" format="h1 air" mode="normal" value="Why intino?">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_430969831" layout="horizontal centercenter" width="-1px" height="300px" spacing="40">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2111162519" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a986664727" format="h5 cardTitle" mode="normal" value="flexibility">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1467195813" format="h5 cardContent" mode="normal" value="Extending benefits beyond software development into modifiability. With intino, software evolution is tailor-made, that is evolving systems built specifically for the needs of particular customer">
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_584249046" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a221037759" format="h5 cardTitle" mode="normal" value="reuse">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a970113197" format="h5 cardContent" mode="normal" value="Developing core components that can be reused. This is the strategy that creates an opportunity for benefits in reducing the effort and costs costs required to create, deploy and software">
								</UiText>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a358947527" layout="vertical" width="28.0%" height="100.0%" paper>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1542032831" format="h5 cardTitle" mode="normal" value="quality">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_293601000" format="h5 cardContent" mode="normal" value="Lowering the complexity of product line development. Application developers can focus on user requirements, getting advantage on the platform architecture that provides a stable quality">
								</UiText>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1762502024" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1255033917" layout="vertical center" width="70.0%" height="100.0%" spacing="40">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1530215354" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1543319719" format="h2 air white" mode="normal" value="What does it look like?">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1005135274" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
				<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1235011590" format="containerAirLarge" layout="vertical" width="-1px" height="500px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_792591400" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a943496642" format="h1" mode="normal" value="software production lines made easy">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_310304387" format="h2" mode="normal" value="symplifying software mass customization">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2007200885" layout="horizontal">
						</UiBlock>
					</UiBlock>
				</UiBlockParallax>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate));
DisplayFactory.register("HomeTemplate", withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate)));