import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiGrouping from "alexandria-ui-elements/src/displays/components/Grouping";
import UiGroupingToolbar from "alexandria-ui-elements/src/displays/components/GroupingToolbar";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import DisplaysGroupingToolbar1Mold from "ui-elements/gen/displays/items/GroupingToolbar1Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import GroupingToolbarExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import GroupingToolbarExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class GroupingToolbarExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new GroupingToolbarExamplesMoldNotifier(this);
		this.requester = new GroupingToolbarExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_724533024" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a253847557" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a954359251" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_774496818" format="filledNoAir" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1572274772" format="filledNoAir" layout="horizontal" spacing="8">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_666032219" format="containerAirMedium" layout="vertical" width="200px" height="-1px" spacing="24">
									<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1072054538" label="gender" format="whiteBackground" pageSize={5}>
									</UiGrouping>
									<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1777326935" label="age group" format="whiteBackground" pageSize={5}>
									</UiGrouping>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_921888655" format="airTop" layout="vertical flexible">
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1567095638" layout="vertical">
										<UiGroupingToolbar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1998539869" format="whiteBackground airBottom">
										</UiGroupingToolbar>
									</UiBlock>
									<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1564801531" pageSize={20} itemHeight={60} scrollingMark={true}>
									</UiList>
								</UiBlock>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1079823677" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a364789582" mode="normal" language="Html" value="GroupingToolbar(groupings=gender ageGroup)&lt;br/&gt;
							Grouping(collections=list1) gender as Labeled(&quot;gender&quot;)&lt;br/&gt;
							Grouping(collections=list1) ageGroup as Labeled(&quot;age group&quot;)&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(GroupingToolbarExamplesMold));
DisplayFactory.register("GroupingToolbarExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(GroupingToolbarExamplesMold)));