import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMap from "alexandria-ui-elements/src/displays/components/Map";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import DisplaysMap1Mold from "ui-elements/gen/displays/items/Map1Mold";
import DisplaysMap2Mold from "ui-elements/gen/displays/items/Map2Mold";
import DisplaysMap3Mold from "ui-elements/gen/displays/items/Map3Mold";
import DisplaysMap4Mold from "ui-elements/gen/displays/items/Map4Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import MapExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import MapExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class MapExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new MapExamplesMoldNotifier(this);
		this.requester = new MapExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1692316900" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1041256438" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_926066304" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1424101489" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1273002339" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}}>
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a365097872" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1540069910" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon=&quot;icons/placemark.png&quot;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; TemplateStamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a344985169" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a762272410" format="h6" mode="normal" value="Clustered facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1369857401" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a340519741" type="Cluster" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:4}}>
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1207708847" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_893321569" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map as Clustered&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; TemplateStamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_462515968" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1530252983" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1898018679" format="h6" mode="normal" value="Heatmap facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a340321217" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a211231486" type="Heatmap" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:4}}>
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1534040209" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a411274279" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map as Heatmap&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; TemplateStamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_552346731" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a726904241" format="h6" mode="normal" value="Kml facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_126942757" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiMap context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1660867104" type="Kml" itemHeight={60} center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:4}}>
							</UiMap>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a281232257" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1500984471" mode="normal" language="Html" value="Map(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) map as Kml(layer=&quot;data/example.kml&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=14, min=1, max=18)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item mapMold &gt; TemplateStamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(MapExamplesMold));
DisplayFactory.register("MapExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(MapExamplesMold)));