import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiFile from "alexandria-ui-elements/src/displays/components/File";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiFileEditable from "alexandria-ui-elements/src/displays/components/FileEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import FileExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import FileExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class FileExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new FileExamplesMoldNotifier(this);
		this.requester = new FileExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1837837576" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1896570833" layout="vertical" width="50.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a261807980" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a931635378" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1937295709" layout="vertical" width="-1px" height="600px">
								<UiFile context={this._context.bind(this)} owner={this._owner.bind(this)} id="a899204558" format="widgetDemo" width="100.0%" height="100.0%">
								</UiFile>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1964546612" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1781226973" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1823468458" layout="vertical" width="50.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2059049175" format="h6" mode="normal" value="Editable facet with drop zone">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1742892934" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_584124016" layout="vertical" width="-1px" height="600px">
								<UiFileEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a702691054" format="widgetDemo" width="100.0%" height="100.0%" dropZone={true}>
								</UiFileEditable>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2115441497" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1276591869" mode="normal" language="Html" value="File(value=&quot;data/example.pdf&quot;) as Relative(width=100%, height=100%) Editable(showDropZone=true)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(FileExamplesMold));
DisplayFactory.register("FileExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(FileExamplesMold)));