import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiExport from "alexandria-ui-elements/src/displays/components/Export";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ExportExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ExportExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ExportExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ExportExamplesMoldNotifier(this);
		this.requester = new ExportExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2130387623" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1464328578" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a180619226" format="h6" mode="normal" value="No facets with from">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1677515244" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiExport context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1577127772" title="export..." target="self" mode="Button" size="Medium" from={1322870400000} range={{min:-1,max:-1}}>
							</UiExport>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1052306897" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_592879117" mode="normal" language="Html" value="Export(title=&quot;export...&quot;, from=&quot;2011-12-03T00:00:00Z&quot;) as Button">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1259747205" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2109524216" format="h6" mode="normal" value="No facets with from and to">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a694468880" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiExport context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1706210492" title="export..." target="self" mode="Button" size="Medium" from={1322870400000} to={1323302400000} min={1322697600000} max={1325289600000} range={{min:-1,max:7}}>
							</UiExport>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596507960" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1859477168" mode="normal" language="Html" value="Button(title=&quot;export...&quot;) as Export&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;from=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;to=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;min=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;max=&quot;2011-12-03T00:00:00Z&quot;&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;rangeMax=7 Days">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2142047840" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_741259797" format="h6" mode="normal" value="No facets with options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1502911206" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiExport context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1964375931" title="export..." target="self" mode="Button" size="Medium" range={{min:-1,max:-1}} options={["a","b"]}>
							</UiExport>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a371253977" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1853435257" mode="normal" language="Html" value="Button(title=&quot;export...&quot;) as Export(options=&quot;a&quot; &quot;b&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(ExportExamplesMold));
DisplayFactory.register("ExportExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(ExportExamplesMold)));