import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDynamicTable from "alexandria-ui-elements/src/displays/components/DynamicTable";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import DisplaysTable1Row from "ui-elements/gen/displays/rows/Table1Row";
import DisplaysTable11Mold from "ui-elements/gen/displays/items/Table11Mold";
import DisplaysTable12Mold from "ui-elements/gen/displays/items/Table12Mold";
import DisplaysTable2Row from "ui-elements/gen/displays/rows/Table2Row";
import DisplaysTable21Mold from "ui-elements/gen/displays/items/Table21Mold";
import DisplaysTable22Mold from "ui-elements/gen/displays/items/Table22Mold";
import DisplaysDynamicTable1Row from "ui-elements/gen/displays/rows/DynamicTable1Row";
import DisplaysDynFirstNameItem from "ui-elements/gen/displays/items/DynFirstNameItem";
import DisplaysDynLastNameItem from "ui-elements/gen/displays/items/DynLastNameItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DynamicTableExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DynamicTableExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DynamicTableExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DynamicTableExamplesMoldNotifier(this);
		this.requester = new DynamicTableExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1526333922" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1011989122" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a364672761" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1418672525" format="filledNoAir" layout="vertical flexible" spacing="8">
							<UiDynamicTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a362894183" itemHeight={60} scrollingMark={true}>
								<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_683697495" style={{width:"30%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a364422081" mode="normal" value="first name">
									</UiText>
								</UiHeading>
								<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1375515036" style={{width:"70%",paddingRight:"10px"}} hidden="Never">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a898775930" mode="normal" value="last name">
									</UiText>
								</UiHeading>
							</UiDynamicTable>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1329269564" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2037216288" mode="normal" language="Html" value="DynamicTable(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) table&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Heading dynFirstNameHeading &gt; Text(value=&quot;first name&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Item(height=60px,width=30%) dynFirstNameItem &gt; Text firstName&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Heading dynLastNameHeading &gt; Text(value=&quot;last name&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Item(height=60px,width=70%) dynLastNameItem &gt; Text lastName&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(DynamicTableExamplesMold));
DisplayFactory.register("DynamicTableExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DynamicTableExamplesMold)));