import ActionableRequester from "./ActionableRequester"

export default class ActionSplitRequester extends ActionableRequester {
	constructor(element) {
		super(element);
	};
	execute = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "execute", s: "actionsplit", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "actionsplit", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}