import BaseLocationNotifier from "./BaseLocationNotifier"

export default class LocationEditableNotifier extends BaseLocationNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshReadonly").toSelf().execute((parameters) => this.element.refreshReadonly(parameters.v));
		this.pushLinked = true;
	};
}