import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Table12MoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import Table12MoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Table12Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Table12MoldNotifier(this);
		this.requester = new Table12MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_672954836" mode="normal" placeholder="">
				</UiTextEditable>
			</div>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(Table12Mold));
DisplayFactory.register("Table12Mold", withStyles(styles, { withTheme: true })(withSnackbar(Table12Mold)));