import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiNumber from "alexandria-ui-elements/src/displays/components/Number";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiNumberEditable from "alexandria-ui-elements/src/displays/components/NumberEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import NumberExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import NumberExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class NumberExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new NumberExamplesMoldNotifier(this);
		this.requester = new NumberExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2014890702" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_324142649" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1622974946" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a657131853" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1741434098" format="body1 widgetDemo" style="Number" value={0.0} decimals={0} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1530373901" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1115528958" mode="normal" language="Html" value="Number(value=10, label=&quot;Campo num&eacute;rico&quot;) number1&lt;br/&gt;
								in java called to number1.countDecimals(10)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1909987638" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_713996450" format="h6" mode="normal" value="No facets with prefix and suffix">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1874679234" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1870516818" format="body1 widgetDemo" style="Number" value={0.0} prefix="Amount" suffix="$" decimals={0} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1777979125" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1625139614" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, prefix=&quot;Amount&quot;, suffix=&quot;$&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1372215813" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_206997234" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1260622973" format="filled" layout="vertical" spacing="8">
							<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1417143524" format="body1 widgetDemo" style="Number" value={0.0} prefix="Price:" suffix="$" min={0.0} max={100.0} step={10.0} decimals={0} expanded={true} helperText="Some important helper text">
							</UiNumberEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_812211451" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a652665217" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, min=0, max=100, step=10, prefix=&quot;Price:&quot;, suffix=&quot;$&quot;) as Editable(helperText=&quot;Some important helper text&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a894090816" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1326557776" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_567857308" format="h6" mode="normal" value="Editable facet with error">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a62505983" format="filled" layout="vertical" spacing="8">
							<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2128682261" format="body1 widgetDemo" style="Number" value={0.0} prefix="Price:" suffix="$" min={0.0} max={100.0} step={10.0} decimals={0} expanded={true}>
							</UiNumberEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1857632120" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a267527433" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, min=0, max=100, step=10, prefix=&quot;Price:&quot;, suffix=&quot;$&quot;) as Editable">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1543803804" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_184949921" format="h6" mode="normal" value="No facets, Currency style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1732832034" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_927465101" format="body1 widgetDemo" style="Currency" value={1.0E8} decimals={2} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1543589626" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2068836573" mode="normal" language="Html" value="Number(value=100000000, style=Currency, countDecimals=2)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a510678331" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1497789955" format="h6" mode="normal" value="No facets, Bytes style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1111594546" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a933622957" format="body1 widgetDemo" style="Bytes" value={2.3232323E7} decimals={2} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1248359842" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_251970363" mode="normal" language="Html" value="Number(value=23232323, style=Bytes, countDecimals=2)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a143125417" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1040462729" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1646321269" format="h6" mode="normal" value="No facets, Exponential style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a427420279" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_710380931" format="body1 widgetDemo" style="Exponential" value={1.2398734202E7} decimals={2} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a338255963" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1592011051" mode="normal" language="Html" value="Number(value=12398734.202, style=Exponential, countDecimals=2)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(NumberExamplesMold));
DisplayFactory.register("NumberExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(NumberExamplesMold)));