import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDownload from "alexandria-ui-elements/src/displays/components/Download";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DownloadExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DownloadExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DownloadExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DownloadExamplesMoldNotifier(this);
		this.requester = new DownloadExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1478808310" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1829037986" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2056624323" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1464967687" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiDownload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_558667276" title="download..." target="self" mode="Button" size="Medium">
							</UiDownload>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_485164082" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1031178092" mode="normal" language="Html" value="Button(title=&quot;download...&quot;) as Download">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_238696967" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1163191472" format="h6" mode="normal" value="No facets with options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1862552678" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiDownload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1064225900" title="download..." target="self" mode="Button" size="Medium" options={["a","b","c"]}>
							</UiDownload>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1766779071" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a881593112" mode="normal" language="Html" value="Button(title=&quot;download...&quot;) as Download(options=&quot;a&quot; &quot;b&quot; &quot;c&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(DownloadExamplesMold));
DisplayFactory.register("DownloadExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(DownloadExamplesMold)));