import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiBlockParallax from "alexandria-ui-elements/src/displays/components/BlockParallax";
import UiOpenDrawer from "alexandria-ui-elements/src/displays/components/OpenDrawer";
import UiBlockDrawer from "alexandria-ui-elements/src/displays/components/BlockDrawer";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiCloseDrawer from "alexandria-ui-elements/src/displays/components/CloseDrawer";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import UiBlockSplitter from "alexandria-ui-elements/src/displays/components/BlockSplitter";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiBlockBadge from "alexandria-ui-elements/src/displays/components/BlockBadge";
import UiOpenPopover from "alexandria-ui-elements/src/displays/components/OpenPopover";
import UiBlockPopover from "alexandria-ui-elements/src/displays/components/BlockPopover";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import BlockExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import BlockExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class BlockExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new BlockExamplesMoldNotifier(this);
		this.requester = new BlockExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1623021144" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a174860871" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2036434079" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1856995612" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1684922714" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_334940638" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a267130582" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a271221941" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1117638765" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a553526086" mode="normal" language="Html" value="Block&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 2&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 3&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1523909274" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1947220577" format="h6" mode="normal" value="No facets with spacing">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a919172924" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1915201946" layout="vertical" spacing="8">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a174113232" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a776184452" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1246520722" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2121858206" layout="vertical">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1296820429" mode="normal" language="Html" value="DP8">
							</UiTextEditableCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a553234598" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1428122211" format="h6" mode="normal" value="No facets with layout">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a84839780" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_471289927" layout="horizontal centercenter" width="-1px" height="175px" spacing="8">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1265708136" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_663636916" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_659545557" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1145310241" layout="vertical">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1288619884" mode="normal" language="Html" value="Horizontal CenterCenter">
							</UiTextEditableCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1763008365" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a853661608" layout="vertical" width="99.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_312283103" format="h6" mode="normal" value="Parallax facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_651263812" format="filled" layout="vertical" spacing="8">
							<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_593039370" layout="vertical" width="-1px" height="175px">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_811284152" layout="horizontal centercenter" width="100.0%" height="100.0%">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_928844430" format="body1 white higgerFont" mode="normal" value="pencils">
									</UiText>
								</UiBlock>
							</UiBlockParallax>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1841327170" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1786901485" mode="normal" language="Html" value="Block as Parallax(value=&quot;images/background1.jpg&quot;) Absolute(height=175px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1316885870" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1956887974" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a864301066" format="h6" mode="normal" value="Drawer facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a181247091" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1120609832" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a307067438" layout="vertical" width="300px" height="-1px" position="Left" variant="Temporary">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1674897286" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a657527830" name="Block_70_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094265656" name="Block_71_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1743408771" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2025560724" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock1)&lt;br/&gt;
							Block drawerBlock1 as Drawer Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1069235993" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_767604260" format="h6" mode="normal" value="Drawer facet with position">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1404625945" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1021274330" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_770746286" layout="vertical" width="300px" height="-1px" position="Right" variant="Temporary">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a766347137" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037613409" name="Block_89_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1047618600" name="Block_90_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1817672063" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1962819850" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock2)&lt;br/&gt;
							Block drawerBlock2 as Drawer(position=Right) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1811194683" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a467470236" format="h6" mode="normal" value="Drawer facet with Persistent variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1027821777" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1903362820" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_755388737" layout="vertical" width="300px" height="-1px" position="Left" variant="Persistent">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_935182156" layout="horizontal endjustified">
									<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_992756704" title="close" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium">
									</UiCloseDrawer>
								</UiBlock>
								<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_451616240">
								</UiDivider>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_885675480" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1558359300" name="Block_110_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1428645402" name="Block_111_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1990812862" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1543116830" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock3)&lt;br/&gt;
							Block drawerBlock3 as Drawer(variant=Persistent) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal EndJustified) &gt; MaterialIconButton(title=&quot;close&quot;, icon=&quot;ChevronLeft&quot;) as CloseDrawer(drawer=drawerBlock3)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Divider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_163590141" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2009862894" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1726853723" format="h6" mode="normal" value="Drawer facet with PersistentAndMini variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1756589088" format="filledNoAir" layout="horizontal">
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_90906048" layout="vertical" width="150px" height="-1px" position="Left" variant="PersistentAndMini">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a4751834" layout="horizontal endjustified" width="-1px" height="45px">
									<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a669018663" title="close" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium">
									</UiCloseDrawer>
								</UiBlock>
								<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1785484441">
								</UiDivider>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1427837641" multipleSelection={false}>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a81371125" layout="horizontal" spacing="16">
										<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a204907082" icon="Build">
										</UiMaterialIcon>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1604096071" name="Block_133_75_01338594671" mode="normal" value="option 1">
										</UiText>
									</UiBlock>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1105477366" layout="horizontal" spacing="16">
										<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2107190554" icon="Face">
										</UiMaterialIcon>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1672554821" name="Block_134_74_1458356688" mode="normal" value="option 2">
										</UiText>
									</UiBlock>
								</UiSelectorListBox>
							</UiBlockDrawer>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_158395332" format="autoHeight" layout="vertical flexible">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_834948725" color="white" layout="horizontal startjustified">
									<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a613334040" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
									</UiOpenDrawer>
								</UiBlock>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2006835314" format="containerAirMedium" mode="normal" value="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris tellus lacus, tristique vitae lectus id, tristique cursus est. Mauris dui dolor, lacinia non accumsan sed, lacinia et eros. Ut eget ornare nunc. Vestibulum at porta tellus, in fringilla tellus. Nam ultricies porta nisi, ut sagittis est lacinia ac. Nunc aliquet, lacus a malesuada pretium, arcu lectus egestas purus, vel euismod nisl ante eget augue. Proin tristique, arcu vitae vehicula cursus, odio nulla congue erat, at porttitor magna dui id quam. In hac habitasse platea dictumst. Etiam id lorem cursus, ultricies felis ut, pretium ante. Aliquam sit amet tellus tellus. Maecenas eget faucibus enim. Pellentesque rutrum augue id pulvinar pharetra. Proin purus ex, tincidunt et posuere vel, dignissim a neque. Aenean quis imperdiet lectus. Pellentesque bibendum ante tincidunt feugiat pharetra. Fusce sollicitudin, magna in mollis vulputate, nunc nunc accumsan lectus, a blandit erat felis a lectus.">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1815067286" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a104255568" mode="normal" language="Html" value="Block(layout=Horizontal EndJustified) &gt; MaterialIconButton(title=&quot;close&quot;, icon=&quot;ChevronLeft&quot;) as CloseDrawer(drawer=drawerBlock1)
							Divider
							MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock1)&lt;br/&gt;
							Block drawerBlock1 as Drawer(variant=PersistentAndMini) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a950822539" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a203759151" format="h6" mode="normal" value="Drawer facet with Permanent variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1118722448" format="filledNoAir" layout="horizontal" spacing="8">
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2068240665" layout="vertical" width="150px" height="-1px" spacing="8" position="Left" variant="Permanent">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_452442167" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_154399331" name="Block_156_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1397551519" name="Block_157_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1880962181" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1980715420" mode="normal" language="Html" value="Block drawerBlock as Drawer(variant=Permanent) Absolute(width=150px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a381884569" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1387789838" format="h6" mode="normal" value="Splitter facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1815666375" format="filled" layout="vertical" spacing="8">
							<UiBlockSplitter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1622247603" layout="horizontal" splitMobileLabel="Back">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1969228658" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a572445495" mode="normal" value="block 1">
									</UiText>
									<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1241018596" title="open 2" target="self" mode="Button" size="Medium">
									</UiAction>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1969228659" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044869090" mode="normal" value="block 2">
									</UiText>
								</UiBlock>
							</UiBlockSplitter>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1956061173" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1998548927" mode="normal" language="Html" value="Block(layout=Horizontal) as Splitter&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block &gt; Text(value=&quot;block 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block &gt; Text(value=&quot;block 2&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1711862780" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2110937526" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1364732835" format="h6" mode="normal" value="Badge facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1141977815" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiBlockBadge context={this._context.bind(this)} owner={this._owner.bind(this)} id="a549237783" layout="horizontal" mode="Normal" value={10}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1525774418" format="body1" mode="normal" value="value">
								</UiText>
							</UiBlockBadge>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2096197573" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_246907897" mode="normal" language="Html" value="Block as Badge(value=10)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1641528871" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a527278930" format="h6" mode="normal" value="Popover facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1181400041" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_324072546" title="open popover" target="self" mode="Button" size="Medium">
							</UiOpenPopover>
							<UiBlockPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_998223214" format="air" layout="horizontal" position="BottomCenter">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1141559563" format="body1" mode="normal" value="popover content">
								</UiText>
							</UiBlockPopover>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2053948672" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341479038" mode="normal" language="Html" value="Button as OpenPopover(popover=popoverBlock)&lt;br/&gt;
							Block popoverBlock as Popover&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;popover content&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(BlockExamplesMold));
DisplayFactory.register("BlockExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(BlockExamplesMold)));