import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiActionSwitch from "alexandria-ui-elements/src/displays/components/ActionSwitch";
import UiActionToggle from "alexandria-ui-elements/src/displays/components/ActionToggle";
import UiActionSplit from "alexandria-ui-elements/src/displays/components/ActionSplit";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ActionableExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ActionableExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ActionableExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ActionableExamplesMoldNotifier(this);
		this.requester = new ActionableExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a242435775" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a488708003" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_624879323" format="h6" mode="normal" value="Link">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_37439465" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1047427129" title="operation" target="self" mode="Link" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1441715751" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a697907834" mode="normal" language="Html" value="Link(title=&quot;operation&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1677393953" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1630657529" format="h6" mode="normal" value="Button">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2117063532" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a460124681" title="operation" target="self" mode="Button" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1435060687" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1780884201" mode="normal" language="Html" value="Button(title=&quot;operation&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_532551326" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_911936407" format="h6" mode="normal" value="IconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1771157987" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1967676491" title="operation" target="self" mode="IconButton" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1270461137" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a509888667" mode="normal" language="Html" value="IconButton(title=&quot;operation&quot;, icon=&quot;/icons/operation.png&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a150262651" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1171560184" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_840888107" format="h6" mode="normal" value="MaterialIconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a650851526" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1830856245" title="operation" target="self" mode="MaterialIconButton" icon="Add" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1979548512" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1998356778" mode="normal" language="Html" value="MaterialIconButton(title=&quot;operation&quot;,icon=&quot;Add&quot;) as Action&lt;br/&gt;&lt;br/&gt;
							for icons gallery, refer to &lt;a href=&quot;https://material.io/tools/icons&quot; target=&quot;_blank&quot;&gt;material.io&lt;/a&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_415282704" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2095557391" format="h6" mode="normal" value="Affirmed facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_13049228" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_828863060" title="operation" target="self" mode="Button" affirmed="Are you sure you want to execute operation?" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_686415074" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1003573330" mode="normal" language="Html" value="Button(title=&quot;operation&quot;) as Action Affirmed(&quot;Are you sure you want to execute operation?&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_536335471" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_523319303" format="h6" mode="normal" value="Highlight attribute">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1940777343" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a678688750" title="operation 1" target="self" mode="Button" size="Medium" highlighted="Outline">
							</UiAction>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a678688751" title="operation 2" target="self" mode="Button" size="Medium" highlighted="Fill">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a215060521" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a706120205" mode="normal" language="Html" value="Button(title=&quot;operation 1&quot;, highlight=&quot;Outline&quot;) as Action&lt;br/&gt;
							Button(title=&quot;operation 2&quot;, highlight=&quot;Fill&quot;) as Action&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a503586809" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1552993395" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_153800413" format="h6" mode="normal" value="Switch">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a735414105" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSwitch context={this._context.bind(this)} owner={this._owner.bind(this)} id="a164006061" title="edition" target="self" mode="Link" size="Medium" state="Off">
							</UiActionSwitch>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_676572731" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_254208534" mode="normal" language="Html" value="Switch(title=&quot;edition&quot;, state=Off) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1114367306" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1608429787" format="h6" mode="normal" value="Signed facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1445038734" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1671557871" title="edition" target="self" mode="Button" signed={{text:"Fill your password before continue",reason:""}} size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1557596750" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1561461471" mode="normal" language="Html" value="Button(title=&quot;edition&quot;) as Action Signed(signText=&quot;Fill your password before continue&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1106875900" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_273858964" format="h6" mode="normal" value="Signed facet with reason property">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1684253675" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_231847928" title="edition" target="self" mode="Button" signed={{text:"Fill your password before continue",reason:"Fill reason"}} size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1020653682" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1170163148" mode="normal" language="Html" value="Button(title=&quot;edition&quot;) as Action Signed(signText=&quot;Fill your password before continue&quot;, reasonText=&quot;Fill reason&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a659174652" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1368059141" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_317183034" format="h6" mode="normal" value="Toggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1594494537" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a324361319" title="edition" target="self" mode="Toggle" size="Medium" state="Off">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_262561760" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1236533438" mode="normal" language="Html" value="Toggle(title=&quot;edition&quot;, state=Off) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1904991684" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1176870227" format="h6" mode="normal" value="IconToggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a81197486" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_186172856" title="operation" target="self" mode="IconToggle" size="Medium" state="Off">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1691086795" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1762212635" mode="normal" language="Html" value="IconToggle(title=&quot;operation&quot;, icon=&quot;/icons/operation.png&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2042854575" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a451276550" format="h6" mode="normal" value="MaterialIconToggle">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a250071601" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionToggle context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_696707034" title="edition" target="self" mode="MaterialIconToggle" icon="FilterList" size="Medium" state="On">
							</UiActionToggle>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a234599642" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_396763173" mode="normal" language="Html" value="MaterialIconToggle(title=&quot;edition&quot;, state=On, icon=&quot;FilterList&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1490337011" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2001750553" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1719584030" format="h6" mode="normal" value="SplitButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1182230706" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiActionSplit context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_893287970" title="edition" target="self" mode="SplitButton" size="Medium" options={["option 1","option 2"]} defaultOption="option 1">
							</UiActionSplit>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_61390328" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_177192422" mode="normal" language="Html" value="SplitButton(title=&quot;edition&quot;, options=&quot;option 1&quot; &quot;option 2&quot;, defaultOption=&quot;option 1&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1830742277" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1207612585" format="h6" mode="normal" value="AvatarIconButton">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a481234653" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1403822146" title="I am avatar" target="self" mode="AvatarIconButton" size="Medium" highlighted="Fill">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a65841592" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1575260089" mode="normal" language="Html" value="AvatarIconButton(title=&quot;I am avatar&quot;) as Action">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(ActionableExamplesMold));
DisplayFactory.register("ActionableExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(ActionableExamplesMold)));