import BaseFileRequester from "./BaseFileRequester"

export default class FileEditableRequester extends BaseFileRequester {
	constructor(element) {
		super(element);
	};
	notifyUploading = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ op: "notifyUploading", s: "fileeditable", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	notifyChange = (value) => {
	    if (this.addToHistory(value)) return;
	    this.fileService.upload({ op: "notifyChange", s: "fileeditable", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context(), v: value}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "fileeditable", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}