import BaseDateNotifier from "./BaseDateNotifier"

export default class DateEditableNotifier extends BaseDateNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshReadonly").toSelf().execute((parameters) => this.element.refreshReadonly(parameters.v));
		this.when("refreshPattern").toSelf().execute((parameters) => this.element.refreshPattern(parameters.v));
		this.when("refreshRange").toSelf().execute((parameters) => this.element.refreshRange(parameters.v));
		this.pushLinked = true;
	};
}