import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class BaseNumberNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refresh").toSelf().execute((parameters) => this.element.refresh(parameters.v));
		this.when("refreshError").toSelf().execute((parameters) => this.element.refreshError(parameters.v));
		this.when("refreshDecimals").toSelf().execute((parameters) => this.element.refreshDecimals(parameters.v));
		this.when("refreshExpanded").toSelf().execute((parameters) => this.element.refreshExpanded(parameters.v));
		this.when("refreshPrefix").toSelf().execute((parameters) => this.element.refreshPrefix(parameters.v));
		this.when("refreshSuffix").toSelf().execute((parameters) => this.element.refreshSuffix(parameters.v));
		this.pushLinked = true;
	};
}