import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiLocation from "alexandria-ui-elements/src/displays/components/Location";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiLocationEditable from "alexandria-ui-elements/src/displays/components/LocationEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import LocationExamplesMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import LocationExamplesMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class LocationExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new LocationExamplesMoldNotifier(this);
		this.requester = new LocationExamplesMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_136087690" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_999388359" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a253987068" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1385951267" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocation context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_429932134" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}}>
							</UiLocation>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a628408525" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_474715924" mode="normal" language="Html" value="Location location&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_986518697" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1911792639" format="h6" mode="normal" value="No facets with location">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1040659958" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocation context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2109102786" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}}>
							</UiLocation>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1468513500" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_352593264" mode="normal" language="Html" value="Location location&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value='POINT(28.146773457066104,-15.146773457066104)'&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_325039372" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1153147118" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1222647296" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_526191826" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocationEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1946608007" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}}>
							</UiLocationEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1288202554" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a830881355" mode="normal" language="Html" value="Location location as Editable&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_913231406" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a668128234" format="h6" mode="normal" value="Editable facet with modes">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1630452371" format="filledNoAirLarge" layout="vertical" spacing="8">
							<UiLocationEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a669188637" center={{lat:28.146773457066104,lng:-15.418557420532238}} zoom={{min:1,max:18,defaultZoom:6}} modes={["Rectangle"]}>
							</UiLocationEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_572848895" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1988653584" mode="normal" language="Html" value="Location location as Editable&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;modes=Rectangle&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Zoom(defaultZoom=6, min=1, max=18)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Center(latitude=28.146773457066104, longitude=-15.418557420532238)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(LocationExamplesMold));
DisplayFactory.register("LocationExamplesMold", withStyles(styles, { withTheme: true })(withSnackbar(LocationExamplesMold)));