import BaseTextRequester from "./BaseTextRequester"

export default class TextEditableCodeRequester extends BaseTextRequester {
	constructor(element) {
		super(element);
	};
	notifyChange = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "notifyChange", s: "texteditablecode", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "texteditablecode", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}