import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysTextExamplesMold from "ui-elements/gen/displays/templates/TextExamplesMold";
import DisplaysNumberExamplesMold from "ui-elements/gen/displays/templates/NumberExamplesMold";
import DisplaysFileExamplesMold from "ui-elements/gen/displays/templates/FileExamplesMold";
import DisplaysImageExamplesMold from "ui-elements/gen/displays/templates/ImageExamplesMold";
import DisplaysDateExamplesMold from "ui-elements/gen/displays/templates/DateExamplesMold";
import DisplaysChartExamplesMold from "ui-elements/gen/displays/templates/ChartExamplesMold";
import DisplaysBlockExamplesMold from "ui-elements/gen/displays/templates/BlockExamplesMold";
import DisplaysListExamplesMold from "ui-elements/gen/displays/templates/ListExamplesMold";
import DisplaysTableExamplesMold from "ui-elements/gen/displays/templates/TableExamplesMold";
import DisplaysMapExamplesMold from "ui-elements/gen/displays/templates/MapExamplesMold";
import DisplaysDownloadExamplesMold from "ui-elements/gen/displays/templates/DownloadExamplesMold";
import DisplaysDownloadSelectionExamplesMold from "ui-elements/gen/displays/templates/DownloadSelectionExamplesMold";
import DisplaysExportExamplesMold from "ui-elements/gen/displays/templates/ExportExamplesMold";
import DisplaysActionableExamplesMold from "ui-elements/gen/displays/templates/ActionableExamplesMold";
import DisplaysGroupingExamplesMold from "ui-elements/gen/displays/templates/GroupingExamplesMold";
import DisplaysSortingExamplesMold from "ui-elements/gen/displays/templates/SortingExamplesMold";
import DisplaysSearchBoxExamplesMold from "ui-elements/gen/displays/templates/SearchBoxExamplesMold";
import DisplaysSliderExamplesMold from "ui-elements/gen/displays/templates/SliderExamplesMold";
import DisplaysDashboardExamplesMold from "ui-elements/gen/displays/templates/DashboardExamplesMold";
import DisplaysDialogExamplesMold from "ui-elements/gen/displays/templates/DialogExamplesMold";
import DisplaysDividerExamplesMold from "ui-elements/gen/displays/templates/DividerExamplesMold";
import DisplaysUserExamplesMold from "ui-elements/gen/displays/templates/UserExamplesMold";
import DisplaysLocationExamplesMold from "ui-elements/gen/displays/templates/LocationExamplesMold";
import DisplaysSelectorExamplesMold from "ui-elements/gen/displays/templates/SelectorExamplesMold";
import DisplaysStepperExamplesMold from "ui-elements/gen/displays/templates/StepperExamplesMold";
import DisplaysFrameExamplesMold from "ui-elements/gen/displays/templates/FrameExamplesMold";
import DisplaysPropertyMold from "ui-elements/gen/displays/templates/PropertyMold";
import DisplaysMethodMold from "ui-elements/gen/displays/templates/MethodMold";
import DisplaysEventsDisplay from "ui-elements/src/displays/EventsDisplay";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import WidgetMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import WidgetMoldRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class WidgetMold extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new WidgetMoldNotifier(this);
		this.requester = new WidgetMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderDynamicLoaded(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1078556726" format="h3" mode="normal" value="Widget">
				</UiText>
				<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_133628978" format="body1" multiple={{instances:"highlightFacets",arrangement:"Horizontal",noItemsMessage:"",spacing:0,editable:false,wrap:true,count:{min:0,max:-1}}} mode="normal" highlighted={{text:"white",background:"#679164"}}>
				</UiMultiple>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1216248666" format="body1 airBottom" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a155673930" layout="vertical" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2123445943" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_31926265" format="h5 underline" mode="normal" value="Examples">
						</UiText>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1723769570" layout="vertical">
							<DisplaysTextExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1250127803">
							</DisplaysTextExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_34138822" layout="vertical">
							<DisplaysNumberExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_135343651">
							</DisplaysNumberExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1571376749" layout="vertical">
							<DisplaysFileExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1387463679">
							</DisplaysFileExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1196301116" layout="vertical">
							<DisplaysImageExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a10200484">
							</DisplaysImageExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1231812255" layout="vertical">
							<DisplaysDateExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1169628818">
							</DisplaysDateExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1192356161" layout="vertical">
							<DisplaysChartExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_658339624">
							</DisplaysChartExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2030181266" layout="vertical">
							<DisplaysBlockExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_340160891">
							</DisplaysBlockExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_371734641" layout="vertical">
							<DisplaysListExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_998735691">
							</DisplaysListExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2064676177" layout="vertical">
							<DisplaysTableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a81058043">
							</DisplaysTableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1971471421" layout="vertical">
							<DisplaysMapExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a568924021">
							</DisplaysMapExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_602353287" layout="vertical">
							<DisplaysDownloadExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_656256841">
							</DisplaysDownloadExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_201275707" layout="vertical">
							<DisplaysDownloadSelectionExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1219691926">
							</DisplaysDownloadSelectionExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a262779557" layout="vertical">
							<DisplaysExportExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a799273610">
							</DisplaysExportExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1353090945" layout="vertical">
							<DisplaysActionableExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1672032393">
							</DisplaysActionableExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_889586956" layout="vertical">
							<DisplaysGroupingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1917917233">
							</DisplaysGroupingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1748807579" layout="vertical">
							<DisplaysSortingExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1978738838">
							</DisplaysSortingExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1028576028" layout="vertical">
							<DisplaysSearchBoxExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1620023127">
							</DisplaysSearchBoxExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a263428818" layout="vertical">
							<DisplaysSliderExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a328473383">
							</DisplaysSliderExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1748560011" layout="vertical">
							<DisplaysDashboardExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1764292433">
							</DisplaysDashboardExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1649293255" layout="vertical">
							<DisplaysDialogExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_67619883">
							</DisplaysDialogExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1308862714" layout="vertical">
							<DisplaysDividerExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a138360889">
							</DisplaysDividerExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2071496124" layout="vertical">
							<DisplaysUserExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a746899712">
							</DisplaysUserExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a227421094" layout="vertical">
							<DisplaysLocationExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1908152755">
							</DisplaysLocationExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1796557360" layout="vertical">
							<DisplaysSelectorExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_897842634">
							</DisplaysSelectorExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1605958478" layout="vertical">
							<DisplaysStepperExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1126850403">
							</DisplaysStepperExamplesMold>
						</UiBlockConditional>
						<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1542842702" layout="vertical">
							<DisplaysFrameExamplesMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1849119476">
							</DisplaysFrameExamplesMold>
						</UiBlockConditional>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1809342582" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a316948462" format="h5 underline" mode="normal" value="Facets">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1451804119" mode="normal">
						</UiText>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1978465968" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1206351146" format="h5 underline" mode="normal" value="Properties">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1588359381" multiple={{instances:"properties",arrangement:"Vertical",noItemsMessage:"no properties",spacing:0,editable:false,wrap:true,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a488042177" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2045862247" format="h5 underline" mode="normal" value="Methods">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_900438787" multiple={{instances:"methods",arrangement:"Vertical",noItemsMessage:"no methods",spacing:0,editable:false,wrap:true,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a163697850" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1835511864" format="h5 underline" mode="normal" value="Events">
						</UiText>
						<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1522943435">
						</UiDisplayStamp>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold));
DisplayFactory.register("WidgetMold", withStyles(styles, { withTheme: true })(withSnackbar(WidgetMold)));