import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractTextExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_515460841" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a898955915" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a926332811" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1532518128" format="filled" layout="vertical" spacing="8">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1900505514" format="body1 widgetDemo" mode="normal">
							</UiText>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1006319667" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1194236294" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text1">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a265791636" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a98066438" format="h6" mode="normal" value="No facets with label">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600994068" format="filled" layout="vertical" spacing="8">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1703992010" label="título del campo" format="body1 widgetDemo" mode="normal">
							</UiText>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_883910335" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1698871398" mode="normal" language="Html" value="Text text2 as Labeled(&quot;t&iacute;tulo del campo&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value=&quot;lorem ipsum&quot;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1223344965" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1757535718" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_366013167" format="filled" layout="vertical" spacing="8">
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_299975957" label="campo editable" format="body1 widgetDemo" mode="normal" placeholder="" helperText="Some important helper text">
							</UiTextEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a507647920" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_11487058" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text3 as Editable(helperText=&quot;Some important helper text&quot;) Labeled(&quot;campo editable&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_356114324" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_179438623" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1580376291" format="h6" mode="normal" value="Editable facet with error">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_602455915" format="filled" layout="vertical" spacing="8">
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1991023372" label="campo editable" format="body1 widgetDemo" mode="normal" placeholder="">
							</UiTextEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2083452779" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a995931385" mode="normal" language="Html" value="Text(value=&quot;lorem ipsum&quot;) text3 as Editable Labeled(&quot;campo editable&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1027612839" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1119532142" format="h6" mode="normal" value="Code facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_36655325" format="filled" layout="vertical" spacing="8">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1401595845" format="body1 widgetDemo" mode="normal" language="Html" value="Text(value=&quot;lorem&quot;) text1">
							</UiTextCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a630988914" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2092989681" mode="normal" language="Html" value="Text textCode1 as Code(language=Html)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;lorem&quot;) text1&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a352376210" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1896733371" format="h6" mode="normal" value="Code and Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1876599850" format="filled" layout="vertical" spacing="8">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1825907080" format="body1 widgetDemo" mode="normal" language="Html" value="&lt;div&gt;Here goes code&lt;/div&gt;">
							</UiTextEditableCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1912159731" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1797104332" mode="normal" language="Html" value="Text textCode1 as Code(language=Html) Editable&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;value&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;lt;div&amp;gt;Here goes code&amp;lt;/div&amp;gt;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;=========&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}