import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiStepper from "alexandria-ui-elements/src/displays/components/Stepper";
import UiStep from "alexandria-ui-elements/src/displays/components/Step";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiDate from "alexandria-ui-elements/src/displays/components/Date";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractStepperExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a996456175" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_233658187" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1427576305" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a35017942" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1420588258" style="Full"    orientation="horizontal" position="bottom">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2128704132" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1720127941" mode="normal" value="hola1">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2128704133" label="Step2">
									<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1850159945" width="200px" height="150px">
									</UiImage>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2128704134" label="Step3">
									<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_45218349" pattern="DD/MM/YYYY">
									</UiDate>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_111596492" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1842404660" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step1 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;hola1&quot;)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step2 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image(defaultValue =&quot; images/image.jpg&quot;) as Absolute(width = 200px, height = 150px)&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step3 as Labeled&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step3&quot;&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Date(pattern = &quot;DD/MM/YYYY&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a547133234" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1014102823" format="h6" mode="normal" value="No facet. Position top, Orientation horizontal">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2094905331" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1232897957" style="Full"    orientation="horizontal" position="top">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_360202748" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1898066728" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_360202747" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_986809907" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_189229919" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a669538951" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Top&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step4 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step5 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a169314351" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1968127414" format="h6" mode="normal" value="No facet. Position left, Orientation vertical">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1731659045" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536446724" style="Full"    orientation="vertical" position="left">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1315720209" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a404710991" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1315720208" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_211994881" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_351183229" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1708874058" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Left&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;orientation = Vertical&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step6 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step7 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2077749599" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1033470001" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1871251481" format="h6" mode="normal" value="No facet. Position right, Orientation vertical">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1417566585" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1982302463" style="Full"    orientation="vertical" position="right">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1503804500" label="Step1">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2064909679" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1503804499" label="Step2">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_654819018" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a328925576" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_624605926" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;position = Right&lt;br/&gt;
								&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;orientation = Vertical&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step8 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step9 as Labeled&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1506222141" layout="vertical" width="33.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a402366798" format="h6" mode="normal" value="MaterialIcon facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_284886196" format="filledNoAirExtraLarge" layout="vertical">
							<UiStepper context={this._context.bind(this)} owner={this._owner.bind(this)} id="a375378727" style="Full"    orientation="horizontal" position="bottom">
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471534589" label="Step1" icon="AddCircle">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1902226344" mode="normal" value="Hello">
									</UiText>
								</UiStep>
								<UiStep context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1471534588" label="Step2" icon="Menu">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a620020234" mode="normal" value="World">
									</UiText>
								</UiStep>
							</UiStepper>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a328774029" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2056328642" mode="normal" language="Html" value="Stepper&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step10 as Labeled MaterialIcon&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step1&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon = &quot;AddCircle&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;Hello&quot;)&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Step step11 as Labeled MaterialIcon&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;label = &quot;Step2&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;icon = &quot;Menu&quot;&lt;br/&gt;
								                            &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;World&quot;)&lt;br/&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}