import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiToolbar from "alexandria-ui-elements/src/displays/components/Toolbar";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiSelectionAction from "alexandria-ui-elements/src/displays/components/SelectionAction";
import DisplaysList1Mold from "ui-elements/gen/displays/items/List1Mold";
import DisplaysList2Mold from "ui-elements/gen/displays/items/List2Mold";
import DisplaysList3Mold from "ui-elements/gen/displays/items/List3Mold";
import DisplaysList4Mold from "ui-elements/gen/displays/items/List4Mold";
import DisplaysList5Mold from "ui-elements/gen/displays/items/List5Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractListExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a429074849" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1384465243" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1980394740" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1680854710" format="filledNoAir" layout="vertical" spacing="8">
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a355045193" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a582063886" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1177529447" mode="normal" language="Html" value="List(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) list&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item listMold &gt; TemplateStamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a140348254" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a475152618" format="h6" mode="normal" value="No facets and no mark on scrolling">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2067216066" format="filledNoAir" layout="vertical" spacing="8">
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a391252336" pageSize={20} itemHeight={60} scrollingMark={false}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1495873367" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1111827025" mode="normal" language="Html" value="List(itemClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;, loadingMark=false) list&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item listMold &gt; TemplateStamp(template=itemMold) stamp&lt;br/&gt;&lt;br/&gt;

							Template(modelClass=&quot;io.intino.alexandria.ui.documentation.Item&quot;) itemMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal Center, spacing=DP8)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Image avatar as Avatar&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text label">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a223053325" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1138457479" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_151483753" format="h6" mode="normal" value="Navigable facet with position Top">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1331849736" format="filledNoAir" layout="vertical" spacing="8">
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_681833043" pageSize={20} itemHeight={60} scrollingMark={true} navigable="Top">
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2022334033" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_263969421" mode="normal" language="Html" value="List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list as Navigable(position=Top)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) listMold &gt; Text firstName as Editable">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_5782081" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1863390630" format="h6" mode="normal" value="Navigable facet with position Bottom">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1763651746" format="filledNoAir" layout="vertical" spacing="8">
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_198288177" pageSize={20} itemHeight={60} scrollingMark={true} navigable="Bottom">
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1933693116" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a571156607" mode="normal" language="Html" value="List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list as Navigable(position=Bottom)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) listMold &gt; Text firstName as Editable">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a483514039" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2106264464" layout="vertical" width="48.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1111314376" format="h6" mode="normal" value="Selectable facet with Toolbar">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1830692935" format="filledNoAir" layout="vertical" spacing="8">
							<UiToolbar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1146236054">
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1064389044" title="add" target="self" mode="MaterialIconButton" icon="Add" size="Medium">
								</UiAction>
								<UiSelectionAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1017534201" title="remove" target="self" mode="MaterialIconButton" icon="Delete" affirmed="Are you sure you want to delete the element?" readonly={true} size="Medium">
								</UiSelectionAction>
							</UiToolbar>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_824035833" pageSize={20} itemHeight={60} scrollingMark={true} selection="multiple">
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1408661442" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_277902887" mode="normal" language="Html" value="Toolbar toolbar5 as Linked(to=list5)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;MaterialIconButton(title=&quot;a&ntilde;adir&quot;, icon=&quot;Add&quot;) add as Action&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;MaterialIconButton(title=&quot;eliminar&quot;, icon=&quot;Delete&quot;) as Action(context=Selection) Affirmed(&quot;Are you sure you want to delete the element?&quot;)&lt;br/&gt;
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list5 as Selectable(multiple=true)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) list5Mold &gt; Text firstName&lt;br/&gt;">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}