import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiToolbar from "alexandria-ui-elements/src/displays/components/Toolbar";
import UiDownloadSelection from "alexandria-ui-elements/src/displays/components/DownloadSelection";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import DisplaysDownloadSelectionMold from "ui-elements/gen/displays/items/DownloadSelectionMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractDownloadSelectionExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1302685046" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1394445162" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1842067689" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a491996481" format="filledNoAir" layout="vertical" spacing="8">
							<UiToolbar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a636664810">
								<UiDownloadSelection context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1248787139" title="download" target="self" mode="Button" affirmed="Are you sure you want to download selection?" readonly={true} size="Medium">
								</UiDownloadSelection>
							</UiToolbar>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1213602937" pageSize={20} itemHeight={60} scrollingMark={true} selection="multiple">
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a55978009" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a282663915" mode="normal" language="Html" value="Toolbar toolbar as Linked(to=list)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Button(title=&quot;download&quot;) download as Download(context=Selection) Affirmed(&quot;Are you sure you want to download selection?&quot;)
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list as Selectable(multiple=true)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) mold &gt; Text firstName">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}