import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDownload from "alexandria-ui-elements/src/displays/components/Download";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractDownloadExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a416503460" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1641750260" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1860304213" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1779903001" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiDownload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_558667276" title="download..." target="self" mode="Button" size="Medium">
							</UiDownload>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1305792032" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a343877706" mode="normal" language="Html" value="Button(title=&quot;download...&quot;) as Download">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_18443741" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2036871480" format="h6" mode="normal" value="No facets with options">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1558734610" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiDownload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1064225900" title="download..." target="self" mode="Button" size="Medium" options={["a","b","c"]}>
							</UiDownload>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1654508217" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1369897756" mode="normal" language="Html" value="Button(title=&quot;download...&quot;) as Download(options=&quot;a&quot; &quot;b&quot; &quot;c&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}