import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiBlockParallax from "alexandria-ui-elements/src/displays/components/BlockParallax";
import UiOpenDrawer from "alexandria-ui-elements/src/displays/components/OpenDrawer";
import UiBlockDrawer from "alexandria-ui-elements/src/displays/components/BlockDrawer";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiCloseDrawer from "alexandria-ui-elements/src/displays/components/CloseDrawer";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import UiBlockSplitter from "alexandria-ui-elements/src/displays/components/BlockSplitter";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiBlockBadge from "alexandria-ui-elements/src/displays/components/BlockBadge";
import UiOpenPopover from "alexandria-ui-elements/src/displays/components/OpenPopover";
import UiBlockPopover from "alexandria-ui-elements/src/displays/components/BlockPopover";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractBlockExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1178485200" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_560592049" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2077432599" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_586041492" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_440890158" layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1860791510" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1258720290" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1254628931" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1906374411" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a553526086" mode="normal" language="Html" value="Block&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 2&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value 3&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a199705234" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1281287769" format="h6" mode="normal" value="No facets with spacing">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a253240116" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1915201946" layout="vertical" spacing="8">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2102198760" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1500127540" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a772134582" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1507176282" layout="vertical">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1296820429" mode="normal" language="Html" value="DP8">
							</UiTextEditableCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a252415646" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1765011435" format="h6" mode="normal" value="No facets with layout">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1543157284" format="filled" layout="vertical" spacing="8">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_471289927" layout="horizontal centercenter" width="-1px" height="175px" spacing="8">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1777558560" format="body1 bordered" mode="normal" value="value 1">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1915337516" format="body1 bordered" mode="normal" value="value 2">
								</UiText>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1911246157" format="body1 bordered" mode="normal" value="value 3">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1296025703" layout="vertical">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1288619884" mode="normal" language="Html" value="Horizontal CenterCenter">
							</UiTextEditableCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a234271515" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1648891488" layout="vertical" width="99.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a782112425" format="h6" mode="normal" value="Parallax facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a443131716" format="filled" layout="vertical" spacing="8">
							<UiBlockParallax context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1140586286" layout="vertical" width="-1px" height="175px">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a973951632" layout="horizontal centercenter" width="100.0%" height="100.0%">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a647966122" format="body1 white higgerFont" mode="normal" value="pencils">
									</UiText>
								</UiBlock>
							</UiBlockParallax>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2020163126" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1786901485" mode="normal" language="Html" value="Block as Parallax(value=&quot;images/background1.jpg&quot;) Absolute(height=175px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a469248266" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1126538030" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a680736274" format="h6" mode="normal" value="Drawer facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1214294165" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1675225888" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a307067438" layout="vertical" width="300px" height="-1px" position="Left" variant="Temporary">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1619525570" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1370300686" name="Block_70_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1902556976" name="Block_71_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a347867515" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2025560724" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock1)&lt;br/&gt;
							Block drawerBlock1 as Drawer Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1035759471" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_478492652" format="h6" mode="normal" value="Drawer facet with position">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1693737553" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1254797598" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_770746286" layout="vertical" width="300px" height="-1px" position="Right" variant="Temporary">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1388186167" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_859928167" name="Block_89_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_537613072" name="Block_90_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a857166919" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_16241134" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock2)&lt;br/&gt;
							Block drawerBlock2 as Drawer(position=Right) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1782239171" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a638901092" format="h6" mode="normal" value="Drawer facet with Persistent variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_856390921" format="filledNoAir" layout="vertical centercenter" spacing="8">
							<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a684911860" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
							</UiOpenDrawer>
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_755388737" layout="vertical" width="300px" height="-1px" position="Left" variant="Persistent">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1137264060" layout="horizontal endjustified">
									<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1108069544" title="close" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium">
									</UiCloseDrawer>
								</UiBlock>
								<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_107668472">
								</UiDivider>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_541727712" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a150730316" name="Block_110_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_140782638" name="Block_111_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1569640838" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_979969702" mode="normal" language="Html" value="MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock3)&lt;br/&gt;
							Block drawerBlock3 as Drawer(variant=Persistent) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal EndJustified) &gt; MaterialIconButton(title=&quot;close&quot;, icon=&quot;ChevronLeft&quot;) as CloseDrawer(drawer=drawerBlock3)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Divider&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_628006773" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1438564570" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a597163427" format="h6" mode="normal" value="Drawer facet with PersistentAndMini variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a839368600" format="filledNoAir" layout="horizontal">
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_90906048" layout="vertical" width="150px" height="-1px" position="Left" variant="PersistentAndMini">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a909602834" layout="horizontal endjustified" width="-1px" height="45px">
									<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748463327" title="close" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium">
									</UiCloseDrawer>
								</UiBlock>
								<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1604631855">
								</UiDivider>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_586552431" multipleSelection={false}>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a995425725" layout="horizontal" spacing="16">
										<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a525109250" icon="Build">
										</UiMaterialIcon>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1924298239" name="Block_133_75_01338594671" mode="normal" value="option 1">
										</UiText>
									</UiBlock>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1127664850" layout="horizontal" spacing="16">
										<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2072744738" icon="Face">
										</UiMaterialIcon>
										<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_978707005" name="Block_134_74_1458356688" mode="normal" value="option 2">
										</UiText>
									</UiBlock>
								</UiSelectorListBox>
							</UiBlockDrawer>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1467587268" format="autoHeight" layout="vertical flexible">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a951735507" color="white" layout="horizontal startjustified">
									<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2116867808" title="open drawer" target="self" mode="MaterialIconButton" icon="Menu" size="Medium">
									</UiOpenDrawer>
								</UiBlock>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1117916346" format="containerAirMedium" mode="normal" value="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris tellus lacus, tristique vitae lectus id, tristique cursus est. Mauris dui dolor, lacinia non accumsan sed, lacinia et eros. Ut eget ornare nunc. Vestibulum at porta tellus, in fringilla tellus. Nam ultricies porta nisi, ut sagittis est lacinia ac. Nunc aliquet, lacus a malesuada pretium, arcu lectus egestas purus, vel euismod nisl ante eget augue. Proin tristique, arcu vitae vehicula cursus, odio nulla congue erat, at porttitor magna dui id quam. In hac habitasse platea dictumst. Etiam id lorem cursus, ultricies felis ut, pretium ante. Aliquam sit amet tellus tellus. Maecenas eget faucibus enim. Pellentesque rutrum augue id pulvinar pharetra. Proin purus ex, tincidunt et posuere vel, dignissim a neque. Aenean quis imperdiet lectus. Pellentesque bibendum ante tincidunt feugiat pharetra. Fusce sollicitudin, magna in mollis vulputate, nunc nunc accumsan lectus, a blandit erat felis a lectus.">
								</UiText>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a116057678" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_585768760" mode="normal" language="Html" value="Block(layout=Horizontal EndJustified) &gt; MaterialIconButton(title=&quot;close&quot;, icon=&quot;ChevronLeft&quot;) as CloseDrawer(drawer=drawerBlock1)
							Divider
							MaterialIconButton(title=&quot;open drawer&quot;, icon=&quot;Menu&quot;) as OpenDrawer(drawer=drawerBlock1)&lt;br/&gt;
							Block drawerBlock1 as Drawer(variant=PersistentAndMini) Absolute(width=300px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a104282707" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1458847769" format="h6" mode="normal" value="Drawer facet with Permanent variant">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1513637928" format="filledNoAir" layout="horizontal" spacing="8">
							<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2068240665" layout="vertical" width="150px" height="-1px" spacing="8" position="Left" variant="Permanent">
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_65033279" multipleSelection={false}>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2033765669" name="Block_156_6_01338594671" mode="normal" value="option 1">
									</UiText>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1049870887" name="Block_157_6_1458356688" mode="normal" value="option 2">
									</UiText>
								</UiSelectorListBox>
							</UiBlockDrawer>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a218355261" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a88811612" mode="normal" language="Html" value="Block drawerBlock as Drawer(variant=Permanent) Absolute(width=150px)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Selector as ListBox&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 1&quot;) as Option&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;option 2&quot;) as Option">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_464655263" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1736902726" format="h6" mode="normal" value="Splitter facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a246735985" format="filled" layout="vertical" spacing="8">
							<UiBlockSplitter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1622247603" layout="horizontal" splitMobileLabel="Back">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1969228658" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_774469761" mode="normal" value="block 1">
									</UiText>
									<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1241018596" title="open 2" target="self" mode="Button" size="Medium">
									</UiAction>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1969228659" layout="vertical">
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1670947306" mode="normal" value="block 2">
									</UiText>
								</UiBlock>
							</UiBlockSplitter>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1848869843" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1998548927" mode="normal" language="Html" value="Block(layout=Horizontal) as Splitter&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block &gt; Text(value=&quot;block 1&quot;)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block &gt; Text(value=&quot;block 2&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1247446148" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1706284354" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a816820763" format="h6" mode="normal" value="Badge facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1336572767" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiBlockBadge context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2126538929" layout="horizontal" mode="Normal" value={10}>
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1317335734" format="body1" mode="normal" value="value">
								</UiText>
							</UiBlockBadge>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1901602621" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_246907897" mode="normal" language="Html" value="Block as Badge(value=10)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;value&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_975459297" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1080723958" format="h6" mode="normal" value="Popover facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_426602847" format="filledNoAir" layout="horizontal centercenter" spacing="8">
							<UiOpenPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1807983398" title="open popover" target="self" mode="Button" size="Medium">
							</UiOpenPopover>
							<UiBlockPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_998223214" format="air" layout="horizontal" position="BottomCenter">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1598012355" format="body1" mode="normal" value="popover content">
								</UiText>
							</UiBlockPopover>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a445945784" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1341479038" mode="normal" language="Html" value="Button as OpenPopover(popover=popoverBlock)&lt;br/&gt;
							Block popoverBlock as Popover&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(value=&quot;popover content&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}