import React from "react";
import DisplaysTable1111Mold from "ui-elements/gen/displays/items/Table1111Mold";
import UiRow from "alexandria-ui-elements/src/displays/components/Row";
import Table111RowNotifier from "../notifiers/Table111RowNotifier";
import Table111RowRequester from "../requesters/Table111RowRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Table111Row extends UiRow {

	constructor(props) {
		super(props);
		this.notifier = new Table111RowNotifier(this);
		this.requester = new Table111RowRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderRow(
			<React.Fragment>
				<DisplaysTable1111Mold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_471517471" style={{width:"30%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never"></DisplaysTable1111Mold>
			</React.Fragment>
		);
	}
}

DisplayFactory.register("Table111Row", Table111Row);