import React from "react";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Table1111MoldNotifier from "../notifiers/Table1111MoldNotifier";
import Table1111MoldRequester from "../requesters/Table1111MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Table1111Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Table1111MoldNotifier(this);
		this.requester = new Table1111MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_746146435" mode="normal" placeholder="">
				</UiTextEditable>
			</div>
		);
	}
}

DisplayFactory.register("Table1111Mold", Table1111Mold);