import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenPage from "alexandria-ui-elements/src/displays/components/OpenPage";
import DisplaysWidgetMold from "ui-elements/src/displays/templates/WidgetMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractWidgetTypeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a96400956" format="air" color="white" position="relative" width="-1px" height="100px" elevation={4}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a352571160" layout="horizontal center" spacing="24">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_830353916" width="80px" height="80px">
						</UiImage>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1586735699" format="h3" mode="normal" value="intino">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a790298661" format="headerToolbar" layout="horizontal center" spacing="24">
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_333187481" title="home" target="self" mode="Link" size="Medium">
							</UiOpenPage>
							<UiOpenPage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1997858655" title="docs" target="self" mode="Link" size="Medium">
							</UiOpenPage>
						</UiBlock>
					</UiBlock>
				</UiHeader>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1824385995" format="containerAirLarge" layout="vertical">
					<DisplaysWidgetMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_621978645">
					</DisplaysWidgetMold>
				</UiBlock>
			</UiBlock>
		);
	}
}