import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSearchBox from "alexandria-ui-elements/src/displays/components/SearchBox";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import DisplaysSearchBox1Mold from "ui-elements/gen/displays/items/SearchBox1Mold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractSearchBoxExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a491659240" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1479844085" layout="vertical" width="49.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_628227029" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1678719711" format="filledNoAir" layout="vertical" spacing="8">
							<UiSearchBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1182136866" label="female population" format="air" placeholder="filter elements...">
							</UiSearchBox>
							<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a819653891" pageSize={20} itemHeight={60} scrollingMark={true}>
							</UiList>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1540261218" layout="vertical">
							<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1533306955" mode="normal" language="Html" value="SearchBox(collections=list,placeholder=&quot;filter elements...&quot;) searchBox
							List(itemClass=&quot;io.intino.alexandria.ui.documentation.Person&quot;) list&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Mold &gt; Item(height=60px,width=30%) sortingMold&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text firstName&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Block(layout=Horizontal, spacing=DP16)&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) gender&lt;br/&gt;
							&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;Text(format=description) age as Labeled(&quot;age&quot;)">
							</UiTextCode>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}