import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiNumber from "alexandria-ui-elements/src/displays/components/Number";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiNumberEditable from "alexandria-ui-elements/src/displays/components/NumberEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractNumberExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1926976615" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_616837844" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1350251893" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_460608586" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1741434098" format="body1 widgetDemo" style="Number" value={0.0} decimals={0} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a684227804" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1115528958" mode="normal" language="Html" value="Number(value=10, label=&quot;Campo num&eacute;rico&quot;) number1&lt;br/&gt;
								in java called to number1.countDecimals(10)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_197220517" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1893159615" format="h6" mode="normal" value="No facets with prefix and suffix">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a186868003" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1870516818" format="body1 widgetDemo" style="Number" value={0.0} prefix="Amount" suffix="$" decimals={0} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1960453798" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1625139614" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, prefix=&quot;Amount&quot;, suffix=&quot;$&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a888599360" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_195685815" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1249311554" format="filled" layout="vertical" spacing="8">
							<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1417143524" format="body1 widgetDemo" style="Number" value={0.0} prefix="Price:" suffix="$" min={0.0} max={100.0} step={10.0} decimals={0} expanded={true} helperText="Some important helper text">
							</UiNumberEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1217188454" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a652665217" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, min=0, max=100, step=10, prefix=&quot;Price:&quot;, suffix=&quot;$&quot;) as Editable(helperText=&quot;Some important helper text&quot;)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1247190795" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a546379495" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_198426999" format="h6" mode="normal" value="Editable facet with error">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a431936292" format="filled" layout="vertical" spacing="8">
							<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2128682261" format="body1 widgetDemo" style="Number" value={0.0} prefix="Price:" suffix="$" min={0.0} max={100.0} step={10.0} decimals={0} expanded={true}>
							</UiNumberEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1145906253" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1007573544" mode="normal" language="Html" value="Number(format=body1 widgetDemo, value=0, min=0, max=100, step=10, prefix=&quot;Price:&quot;, suffix=&quot;$&quot;) as Editable">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_878226221" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a204960568" format="h6" mode="normal" value="No facets, Currency style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_334780955" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1954095414" format="body1 widgetDemo" style="Currency" value={1.0E8} decimals={2} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a990609039" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1506346604" mode="normal" language="Html" value="Number(value=100000000, style=Currency, countDecimals=2)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1922756316" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a928881894" format="h6" mode="normal" value="No facets, Bytes style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_756700901" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a935613414" format="body1 widgetDemo" style="Bytes" value={2.3232323E7} decimals={2} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1246369385" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_202907560" mode="normal" language="Html" value="Number(value=23232323, style=Bytes, countDecimals=2)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a496225396" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1261420886" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_742729278" format="h6" mode="normal" value="No facets, Exponential style">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1625999072" format="filled" layout="vertical" spacing="8">
							<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2092550492" format="body1 widgetDemo" style="Exponential" value={1.2398734202E7} decimals={2} expanded={true}>
							</UiNumber>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1043913598" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_956092126" mode="normal" language="Html" value="Number(value=12398734.202, style=Exponential, countDecimals=2)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}