import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDate from "alexandria-ui-elements/src/displays/components/Date";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiDateEditable from "alexandria-ui-elements/src/displays/components/DateEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractDateExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_696163876" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2044913948" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a394728043" format="h6" mode="normal" value="No facets">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1214346565" format="filled" layout="vertical" spacing="8">
							<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a499218984" format="body1 widgetDemo" pattern="MM/DD/YYYY">
							</UiDate>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a471832677" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2135750664" mode="normal" language="Html" value="Date(pattern=&quot;MM/DD/YYYY&quot;) date1&lt;br/&gt;&lt;br/&gt;
								&lt;i&gt;pattern&lt;/i&gt; is defined using &lt;a href=&quot;https://momentjs.com/docs/#/displaying/format/&quot; target=&quot;_blank&quot;&gt;momentjs format&lt;/a&gt;">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_275130047" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1415436868" format="h6" mode="normal" value="No facets with Mode">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_913954752" format="filled" layout="vertical" spacing="8">
							<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1504748983" format="body1 widgetDemo" pattern="DD/MM/YYYY" mode="fromnow">
							</UiDate>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a817836846" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1361178521" mode="normal" language="Html" value="Date(mode=FromNow) date2">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1827804510" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1630762648" format="h6" mode="normal" value="Editable facet">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_784964368" format="filled" layout="vertical" spacing="8">
							<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1701262487" format="body1 widgetDemo" pattern="DD/MM/YYYY">
							</UiDateEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a204961058" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a856543417" mode="normal" language="Html" value="Date date3 as Editable">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1948752055" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1694444360" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a777327160" format="h6" mode="normal" value="Editable facet with timePicker">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1071260569" format="filled" layout="vertical" spacing="8">
							<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a589736842" format="body1 widgetDemo" pattern="DD/MM/YYYY HH:mm" timePicker={true}>
							</UiDateEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_183543203" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_234897701" mode="normal" language="Html" value="Date date4 as Editable(timePicker=true)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1548323014" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1309662389" format="h6" mode="normal" value="Editable facet allowing empty">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1668678553" format="filled" layout="vertical" spacing="8">
							<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1414231125" format="body1 widgetDemo" pattern="DD/MM/YYYY HH:mm" allowEmpty={true}>
							</UiDateEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1389321207" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1032935812" mode="normal" language="Html" value="Date date as Editable(allowEmpty=true)">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}