import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiChart from "alexandria-ui-elements/src/displays/components/Chart";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractChartExamplesMold extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" spacing="8" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1620724679" layout="horizontal" spacing="24">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1594269586" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_654912735" format="h6" mode="normal" value="No facets with Html output">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2098334410" format="filled" layout="vertical" spacing="8">
							<UiChart context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1936708868">
							</UiChart>
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a878447497" mode="normal" language="R" value="output = qplot(Petal.Width, Sepal.Length, data = iris, color = Species)">
							</UiTextEditableCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1881970240" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1202917863" mode="normal" language="Html" value="DataFrame iris as CSV(&quot;data/iris.csv&quot;)
								Chart(input=iris, query=&quot;&quot;) chart">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a617609964" layout="vertical" width="32.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_98748711" format="h6" mode="normal" value="No facets with Image output">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1220824923" format="filled" layout="vertical" spacing="8">
							<UiChart context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1432157794">
							</UiChart>
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_332930901" mode="normal" language="R" value="set.seed(100);\\n
							d = diamonds[sample(nrow(diamonds), 1000), ];\\n
							output = ggplot(data = d, aes(x = carat, y = price)) + geom_point(aes(text = paste(&quot;Clarity:&quot;, clarity)), size = 4) + geom_smooth(aes(colour = cut, fill = cut)) + facet_wrap(~ cut);">
							</UiTextEditableCode>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1766560014" layout="vertical">
								<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1691151877" mode="normal" language="Html" value="DataFrame iris as CSV(&quot;data/iris.csv&quot;)
								Chart(input=iris, query=&quot;&quot;, output=Image) chart">
								</UiTextCode>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}