import Requester from "./Requester";

export default class DashboardRequester extends Requester {
	constructor(element) {
		super(element);
	};
	showSettings = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ op: "showSettings", s: "dashboard", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	hideSettings = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ op: "hideSettings", s: "dashboard", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
	saveServerScript = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "saveServerScript", s: "dashboard", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	saveUiScript = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "saveUiScript", s: "dashboard", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
}