import Requester from "./Requester";

export default class CollectionRequester extends Requester {
	constructor(element) {
		super(element);
	};
	selection = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ op: "selection", s: "collection", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	selectAll = () => {
	    if (this.addToHistory()) return;
	    this.pushService.send({ op: "selectAll", s: "collection", d: this.element.props.id, o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
	};
}