import React from "react";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Table22MoldNotifier from "../notifiers/Table22MoldNotifier";
import Table22MoldRequester from "../requesters/Table22MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Table22Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Table22MoldNotifier(this);
		this.requester = new Table22MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1243172595" mode="normal">
				</UiText>
			</div>
		);
	}
}

DisplayFactory.register("Table22Mold", Table22Mold);