import React from "react";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Table21MoldNotifier from "../notifiers/Table21MoldNotifier";
import Table21MoldRequester from "../requesters/Table21MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Table21Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Table21MoldNotifier(this);
		this.requester = new Table21MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_879733616" mode="normal">
				</UiText>
			</div>
		);
	}
}

DisplayFactory.register("Table21Mold", Table21Mold);