import React from "react";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Sorting1MoldNotifier from "../notifiers/Sorting1MoldNotifier";
import Sorting1MoldRequester from "../requesters/Sorting1MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Sorting1Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Sorting1MoldNotifier(this);
		this.requester = new Sorting1MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_100315484" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1075366946" layout="horizontal" spacing="16">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1612664234" format="description" mode="normal">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1173666504" label="age" format="description" mode="normal">
					</UiText>
				</UiBlock>
			</div>
		);
	}
}

DisplayFactory.register("Sorting1Mold", Sorting1Mold);