import React from "react";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Selector8ListMoldNotifier from "../notifiers/Selector8ListMoldNotifier";
import Selector8ListMoldRequester from "../requesters/Selector8ListMoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Selector8ListMold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Selector8ListMoldNotifier(this);
		this.requester = new Selector8ListMoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1200441029" mode="normal">
				</UiText>
			</div>
		);
	}
}

DisplayFactory.register("Selector8ListMold", Selector8ListMold);