import React from "react";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import SearchBox1MoldNotifier from "../notifiers/SearchBox1MoldNotifier";
import SearchBox1MoldRequester from "../requesters/SearchBox1MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class SearchBox1Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new SearchBox1MoldNotifier(this);
		this.requester = new SearchBox1MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a470861507" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a670833821" layout="horizontal" spacing="16">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a614608842" format="description" mode="normal">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1453365016" label="age" format="description" mode="normal">
					</UiText>
				</UiBlock>
			</div>
		);
	}
}

DisplayFactory.register("SearchBox1Mold", SearchBox1Mold);