import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import DisplaysItemMold from "ui-elements/src/displays/templates/ItemMold";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Map4MoldNotifier from "../notifiers/Map4MoldNotifier";
import Map4MoldRequester from "../requesters/Map4MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Map4Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Map4MoldNotifier(this);
		this.requester = new Map4MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<DisplaysItemMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1778682019">
				</DisplaysItemMold>
			</div>
		);
	}
}

DisplayFactory.register("Map4Mold", Map4Mold);