import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import DisplaysItemMold from "ui-elements/src/displays/templates/ItemMold";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Map3MoldNotifier from "../notifiers/Map3MoldNotifier";
import Map3MoldRequester from "../requesters/Map3MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Map3Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Map3MoldNotifier(this);
		this.requester = new Map3MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<DisplaysItemMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1966682177">
				</DisplaysItemMold>
			</div>
		);
	}
}

DisplayFactory.register("Map3Mold", Map3Mold);