import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import DisplaysItemMold from "ui-elements/src/displays/templates/ItemMold";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import Map2MoldNotifier from "../notifiers/Map2MoldNotifier";
import Map2MoldRequester from "../requesters/Map2MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class Map2Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new Map2MoldNotifier(this);
		this.requester = new Map2MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<DisplaysItemMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1679529675">
				</DisplaysItemMold>
			</div>
		);
	}
}

DisplayFactory.register("Map2Mold", Map2Mold);