import React from "react";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import List4MoldNotifier from "../notifiers/List4MoldNotifier";
import List4MoldRequester from "../requesters/List4MoldRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';

export default class List4Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new List4MoldNotifier(this);
		this.requester = new List4MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1008211842" mode="normal" placeholder="">
				</UiTextEditable>
			</div>
		);
	}
}

DisplayFactory.register("List4Mold", List4Mold);